<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicantsTable extends Migration {

	public function up()
	{
		Schema::create('applicants', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('degree_level', array('I', 'II', 'III', 'IV', 'V'));
			$table->string('degree_infos', 255)->nullable()->index();
			$table->text('additional_information')->nullable();
			$table->integer('person_id')->unsigned()->index();
			$table->integer('job_id')->unsigned()->nullable();
			$table->integer('title_id')->unsigned()->nullable();
			$table->integer('statute_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('applicants');
	}
}