<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandsTable extends Migration {

	public function up()
	{
		Schema::create('brands', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->unique();
			$table->string('url', 766);
			$table->string('description', 1024);
			$table->string('related_keywords', 1024);
			$table->binary('youtube_cache');
			$table->date('youtube_cache_updated');
			$table->binary('reddit_cache');
			$table->date('reddit_cache_updated');
			$table->integer('submitted_by_user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('brands');
	}
}