<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('brands', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('time_zones_id')->references('id')->on('time_zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores_list', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores_list', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('companies_types_id')->references('id')->on('companies_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sms_companies', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_companies', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('landing_page_templates', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('landing_page_templates_placeholders', function(Blueprint $table) {
			$table->foreign('landing_page_template_id')->references('id')->on('landing_page_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('landing_pages', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('landing_pages', function(Blueprint $table) {
			$table->foreign('landing_page_template_id')->references('id')->on('landing_page_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->foreign('landing_page_id')->references('id')->on('landing_pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('brands', function(Blueprint $table) {
			$table->dropForeign('brands_country_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_time_zones_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('stores_list', function(Blueprint $table) {
			$table->dropForeign('stores_list_brand_id_foreign');
		});
		Schema::table('stores_list', function(Blueprint $table) {
			$table->dropForeign('stores_list_city_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_brand_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_companies_types_id_foreign');
		});
		Schema::table('sms_companies', function(Blueprint $table) {
			$table->dropForeign('sms_companies_company_id_foreign');
		});
		Schema::table('email_companies', function(Blueprint $table) {
			$table->dropForeign('email_companies_company_id_foreign');
		});
		Schema::table('landing_page_templates', function(Blueprint $table) {
			$table->dropForeign('landing_page_templates_brand_id_foreign');
		});
		Schema::table('landing_page_templates_placeholders', function(Blueprint $table) {
			$table->dropForeign('landing_page_templates_placeholders_landing_page_template_id_foreign');
		});
		Schema::table('landing_pages', function(Blueprint $table) {
			$table->dropForeign('landing_pages_company_id_foreign');
		});
		Schema::table('landing_pages', function(Blueprint $table) {
			$table->dropForeign('landing_pages_landing_page_template_id_foreign');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->dropForeign('sources_brand_id_foreign');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->dropForeign('sources_landing_page_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_source_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_brand_id_foreign');
		});
	}
}