<?php

namespace NH7Weekender;

use Illuminate\Database\Eloquent\Model;

class Artist extends Model 
{

    protected $table = 'nh7_artist';
    public $timestamps = true;
    protected $fillable = array('avatar', 'cover_img', 'name', 'is_active', 'real_name', 'nick_name', 'description', 'seo_title', 'seo_keywords', 'seo_description', 'facebook_url', 'twitter_url', 'youtube_url', 'instagram_url', 'soundcloud_url', 'bandcamp_url', 'website', 'slug', 'owner', 'last_updated_by');

    public function getWork()
    {
        return $this->hasMany('NH7Weekender\ArtistWork', 'artist_id');
    }

}