<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('nh7_city', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('nh7_event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_venue', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('nh7_event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_venue', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('nh7_city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_venue_facility', function(Blueprint $table) {
			$table->foreign('venue_id')->references('id')->on('nh7_venue')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_artist_work', function(Blueprint $table) {
			$table->foreign('artist_id')->references('id')->on('nh7_artist')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_sponsor', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('nh7_event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('nh7_event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('nh7_city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival', function(Blueprint $table) {
			$table->foreign('venue_id')->references('id')->on('nh7_venue')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival_artist', function(Blueprint $table) {
			$table->foreign('festival_id')->references('id')->on('nh7_festival')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival_artist', function(Blueprint $table) {
			$table->foreign('artist_id')->references('id')->on('nh7_artist')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival_ticket', function(Blueprint $table) {
			$table->foreign('festival_id')->references('id')->on('nh7_festival')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_faq', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('nh7_event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_faq', function(Blueprint $table) {
			$table->foreign('faq_category_id')->references('id')->on('nh7_faq_category')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_festival_sponsor', function(Blueprint $table) {
			$table->foreign('festival_id')->references('id')->on('nh7_festival')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nh7_gallery', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('nh7_event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('nh7_gallery', function(Blueprint $table) {
			$table->foreign('festival_id')->references('id')->on('nh7_festival')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('nh7_city', function(Blueprint $table) {
			$table->dropForeign('nh7_city_event_id_foreign');
		});
		Schema::table('nh7_venue', function(Blueprint $table) {
			$table->dropForeign('nh7_venue_event_id_foreign');
		});
		Schema::table('nh7_venue', function(Blueprint $table) {
			$table->dropForeign('nh7_venue_city_id_foreign');
		});
		Schema::table('nh7_venue_facility', function(Blueprint $table) {
			$table->dropForeign('nh7_venue_facility_venue_id_foreign');
		});
		Schema::table('nh7_artist_work', function(Blueprint $table) {
			$table->dropForeign('nh7_artist_work_artist_id_foreign');
		});
		Schema::table('nh7_sponsor', function(Blueprint $table) {
			$table->dropForeign('nh7_sponsor_event_id_foreign');
		});
		Schema::table('nh7_festival', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_event_id_foreign');
		});
		Schema::table('nh7_festival', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_city_id_foreign');
		});
		Schema::table('nh7_festival', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_venue_id_foreign');
		});
		Schema::table('nh7_festival_artist', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_artist_festival_id_foreign');
		});
		Schema::table('nh7_festival_artist', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_artist_artist_id_foreign');
		});
		Schema::table('nh7_festival_ticket', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_ticket_festival_id_foreign');
		});
		Schema::table('nh7_faq', function(Blueprint $table) {
			$table->dropForeign('nh7_faq_event_id_foreign');
		});
		Schema::table('nh7_faq', function(Blueprint $table) {
			$table->dropForeign('nh7_faq_faq_category_id_foreign');
		});
		Schema::table('nh7_festival_sponsor', function(Blueprint $table) {
			$table->dropForeign('nh7_festival_sponsor_festival_id_foreign');
		});
		Schema::table('nh7_gallery', function(Blueprint $table) {
			$table->dropForeign('nh7_gallery_event_id_foreign');
		});
		Schema::table('nh7_gallery', function(Blueprint $table) {
			$table->dropForeign('nh7_gallery_festival_id_foreign');
		});
	}
}