<?php

namespace NH7Weekender;

class Festival extends Eloquent {

	protected $table = 'nh7_festival';
	public $timestamps = true;
	protected $fillable = array('event_id', 'avatar', 'is_active', 'title', 'city_id', 'city', 'venue_id', 'ticket_link', 'start_date', 'end_date', 'sequence_no', 'description', 'seo_title', 'seo_keywords', 'seo_description', 'slug', 'owner', 'last_updated_by');

	public function getArtist()
	{
		return $this->hasMany('NH7Weekender\FestivalArtist', 'festival_id');
	}

	public function getTickets()
	{
		return $this->hasMany('NH7Weekender\FestivalTicket', 'festival_id');
	}

	public function getSponsors()
	{
		return $this->hasMany('NH7Weekender\FestivalSponsor', 'festival_id');
	}

}