<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7EventTable extends Migration {

	public function up()
	{
		Schema::create('nh7_event', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->boolean('is_active')->default(1);
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_event');
	}
}