<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7FaqTable extends Migration {

	public function up()
	{
		Schema::create('nh7_faq', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->integer('faq_category_id')->unsigned();
			$table->string('faq_category')->nullable();
			$table->text('question');
			$table->text('answer');
			$table->boolean('is_active')->default(1);
			$table->integer('sequence_no')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_faq');
	}
}