<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNh7FestivalTable extends Migration {

	public function up()
	{
		Schema::create('nh7_festival', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->string('avatar')->nullable();
			$table->boolean('is_active')->default(1);
			$table->string('title');
			$table->integer('city_id')->unsigned();
			$table->string('city');
			$table->integer('venue_id')->unsigned();
			$table->text('ticket_link')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->integer('sequence_no')->nullable();
			$table->text('description')->nullable();
			$table->string('seo_title')->nullable();
			$table->text('seo_keywords')->nullable();
			$table->text('seo_description')->nullable();
			$table->string('slug');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nh7_festival');
	}
}