<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('ext');
			$table->string('url');
			$table->string('type');
			$table->integer('width');
			$table->integer('height');
			$table->string('mime');
			$table->bigInteger('attachmentable_id');
			$table->string('attachmentable_type');
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}