<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvestorTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('investor_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('old_balance', 20,2)->default('0');
			$table->decimal('balance', 20,2);
			$table->decimal('amount', 20,2);
			$table->integer('investor_id');
			$table->tinyInteger('operation');
			$table->text('details_ar')->nullable();
			$table->text('details_en')->nullable();
			$table->integer('user_id');
			$table->integer('investment_id')->nullable();
			$table->integer('chance_id');
		});
	}

	public function down()
	{
		Schema::drop('investor_transactions');
	}
}