<?php

namespace App;

class FeedbackBawahan extends Eloquent {

	protected $table = 'feedback_bawahan';
	public $timestamps = true;

	public function perilaku()
	{
		return $this->belongsTo('App\PerilakuLiquid', 'perilaku_id', 'id');
	}

	public function aspek()
	{
		return $this->belongsTo('App\Aspek', 'aspek_id', 'id');
	}

	public function jadwalLiquid()
	{
		return $this->belongsTo('App\JadwalLiquid', 'jadwal_liquid_id', 'id');
	}

	public function penilaianAtasan()
	{
		return $this->belongsTo('App\PenilaianAtasan', 'penilaian_atasan_id', 'id');
	}

	public function userPegawai()
	{
		return $this->belongsTo('App\User', 'nip_pegawai', 'nip');
	}

	public function userAtasan()
	{
		return $this->belongsTo('App\User', 'nip_atasan', 'nip');
	}

	public function feedback()
	{
		return $this->belongsTo('App\Feedback', 'feedback_id', 'id');
	}

}