<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMconditionsTable extends Migration {

	public function up()
	{
		Schema::create('mconditions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('mclient_id')->unsigned();
			$table->integer('age_from');
			$table->integer('age_to');
			$table->integer('height_from');
			$table->integer('height_to')->nullable();
			$table->integer('residence_id')->unsigned();
			$table->integer('nationality_id')->unsigned();
			$table->string('origin')->nullable();
			$table->string('tribe')->nullable();
			$table->enum('educational_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('work', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('social_status', array('c', 'd', 'b', 'a'));
			$table->enum('money_level', array('c', 'd', 'b', 'a'));
			$table->enum('health_status', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('religion_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('beauty', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('skin_color', array('c', 'd', 'b', 'a'))->nullable();
			$table->longText('detailed')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mconditions');
	}
}