<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFclientsTable extends Migration {

	public function up()
	{
		Schema::create('fclients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone')->nullable();
			$table->string('address_file')->unique()->nullable();
			$table->string('password')->nullable();
			$table->string('email')->unique()->nullable();
			$table->integer('nationality_id')->unsigned();
			$table->string('origin')->nullable();
			$table->string('tribe')->nullable();
			$table->string('other')->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('residence_id')->unsigned();
			$table->enum('social_status', array('c', 'd', 'b', 'a'))->nullable();
			$table->integer('children_count')->unsigned()->nullable();
			$table->integer('age')->unsigned()->nullable();
			$table->enum('educational_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('work', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('money_level', array(''))->nullable();
			$table->enum('health_status', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('beauty', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('religion_level', array('c', 'd', 'b', 'a'))->nullable();
			$table->enum('skin_color', array(''))->nullable();
			$table->integer('weight')->unsigned()->nullable();
			$table->integer('height')->unsigned()->nullable();
			$table->longText('detailed')->nullable();
			$table->enum('accepting_polygamy', array(''))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fclients');
	}
}