<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('area_districts', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('area_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_upazila_thanas', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('area_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_upazila_thanas', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('area_districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_post_offices', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('area_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_post_offices', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('area_districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_post_offices', function(Blueprint $table) {
			$table->foreign('upazila_thana_id')->references('id')->on('area_upazila_thanas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_unions', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('area_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_unions', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('area_districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_unions', function(Blueprint $table) {
			$table->foreign('upazila_thana_id')->references('id')->on('area_upazila_thanas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('area_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('area_districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('upazila_thana_id')->references('id')->on('area_upazila_thanas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('post_office_id')->references('id')->on('area_post_offices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('union_id')->references('id')->on('area_unions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('user_type_details_id')->references('id')->on('user_type_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('area_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('area_districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->foreign('upazila_thana_id')->references('id')->on('area_upazila_thanas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->foreign('union_id')->references('id')->on('area_unions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_type_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('area_districts', function(Blueprint $table) {
			$table->dropForeign('area_districts_division_id_foreign');
		});
		Schema::table('area_upazila_thanas', function(Blueprint $table) {
			$table->dropForeign('area_upazila_thanas_division_id_foreign');
		});
		Schema::table('area_upazila_thanas', function(Blueprint $table) {
			$table->dropForeign('area_upazila_thanas_district_id_foreign');
		});
		Schema::table('area_post_offices', function(Blueprint $table) {
			$table->dropForeign('area_post_offices_division_id_foreign');
		});
		Schema::table('area_post_offices', function(Blueprint $table) {
			$table->dropForeign('area_post_offices_district_id_foreign');
		});
		Schema::table('area_post_offices', function(Blueprint $table) {
			$table->dropForeign('area_post_offices_upazila_thana_id_foreign');
		});
		Schema::table('area_unions', function(Blueprint $table) {
			$table->dropForeign('area_unions_division_id_foreign');
		});
		Schema::table('area_unions', function(Blueprint $table) {
			$table->dropForeign('area_unions_district_id_foreign');
		});
		Schema::table('area_unions', function(Blueprint $table) {
			$table->dropForeign('area_unions_upazila_thana_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_division_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_district_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_upazila_thana_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_post_office_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_union_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_user_type_details_id_foreign');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->dropForeign('area_wards_division_id_foreign');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->dropForeign('area_wards_district_id_foreign');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->dropForeign('area_wards_upazila_thana_id_foreign');
		});
		Schema::table('area_wards', function(Blueprint $table) {
			$table->dropForeign('area_wards_union_id_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
		Schema::table('user_type_details', function(Blueprint $table) {
			$table->dropForeign('user_type_details_user_id_foreign');
		});
	}
}