<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressesTable extends Migration {

	public function up()
	{
		Schema::create('user_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('present', 'permanent'));
			$table->string('holding', 150);
			$table->bigInteger('division_id')->unsigned();
			$table->bigInteger('district_id')->unsigned();
			$table->bigInteger('upazila_thana_id')->unsigned();
			$table->bigInteger('post_office_id')->unsigned();
			$table->bigInteger('union_id')->unsigned();
			$table->timestamps();
			$table->bigInteger('user_type_details_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('user_addresses');
	}
}