<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuyersTable extends Migration {

	public function up()
	{
		Schema::create('buyers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 64)->unique();
			$table->string('name', 32);
			$table->string('email');
			$table->string('phone', 32);
			$table->text('address');
			$table->integer('payment_terms_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('buyers');
	}
}