<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email')->unique();
			$table->string('username', 32)->unique();
			$table->string('password');
			$table->text('token');
			$table->string('name');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}