<?php

class Campaign extends Eloquent {

	protected $table = 'campaigns';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'start_date', 'end_date', 'status', 'business_id', 'user_id', 'subscription', 'post_count', 'data');
	protected $visible = array('name', 'description', 'start_date', 'end_date', 'status', 'business_id', 'user_id', 'subscription', 'post_count', 'data');

	public function business()
	{
		return $this->belongsTo('\Business');
	}

	public function user()
	{
		return $this->belongsTo('\Users');
	}

	public function influencers()
	{
		return $this->hasManyThrough('Influencer', 'CampaignInfluencer')->withPivot('campaign_influencer_pivot');
	}

}