<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned()->index();
			$table->integer('created_id')->unsigned()->index();
			$table->integer('updated_id')->unsigned()->index();
			$table->integer('assigned_id')->unsigned()->index();
			$table->enum('type', array('maintenance', 'repair'))->index();
			$table->enum('status', array('open', 'closed', 'assigned'))->index();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}