<?php

namespace models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Facility extends Eloquent {

	protected $table = 'facilits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'owner_id', 'category_id');

	public function owner()
	{
		return $this->belongsTo('Owner', 'owner_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function town()
	{
		return $this->belongsTo('Town', 'town_id');
	}

	public function images()
	{
		return $this->morphMany('Images');
	}

}