<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function shipping_info()
    {
        return $this->hasOne('\ShippingInformation');
    }

    public function order_detail()
    {
        return $this->hasOne('OrderDetails');
    }

}