<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cuenta extends Model 
{

    protected $table = 'cuentas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cuenta', 'clabe');

    public function banco()
    {
        return $this->hasOne('App\Banco', 'banco_id');
    }

    public function tipoCuenta()
    {
        return $this->hasOne('Tipocuenta');
    }

}