<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivacionesTable extends Migration {

	public function up()
	{
		Schema::create('activaciones', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('distribuidor_id')->unsigned();
			$table->bigInteger('semana_id')->unsigned();
			$table->datetime('fechahora_pago')->nullable();
			$table->bigInteger('tipo_activacion_id')->unsigned();
			$table->integer('cantidad_requerida')->unsigned();
			$table->integer('cantidad_comprada')->nullable();
			$table->float('precio_unitario');
			$table->float('total_a_pagar');
			$table->float('total_pagado');
			$table->float('saldo');
			$table->integer('estatus_activacion')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('activaciones');
	}
}