<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('distribuidores', function(Blueprint $table) {
			$table->foreign('organizacion_id')->references('id')->on('organizaciones')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('distribuidores', function(Blueprint $table) {
			$table->foreign('cuenta_id')->references('id')->on('cuentas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comisiones', function(Blueprint $table) {
			$table->foreign('distribuidor_id')->references('id')->on('distribuidores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comisiones', function(Blueprint $table) {
			$table->foreign('tipo_activacion_id')->references('id')->on('tipos_activaciones')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comisiones', function(Blueprint $table) {
			$table->foreign('semana_id')->references('id')->on('semanas')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comisiones_detalle', function(Blueprint $table) {
			$table->foreign('comision_id')->references('id')->on('comisiones')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comisiones_detalle', function(Blueprint $table) {
			$table->foreign('distribuidor_id')->references('id')->on('distribuidores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('activaciones', function(Blueprint $table) {
			$table->foreign('distribuidor_id')->references('id')->on('distribuidores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('activaciones', function(Blueprint $table) {
			$table->foreign('semana_id')->references('id')->on('semanas')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('activaciones', function(Blueprint $table) {
			$table->foreign('tipo_activacion_id')->references('id')->on('tipos_activaciones')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pagos', function(Blueprint $table) {
			$table->foreign('activacion_id')->references('id')->on('activaciones')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pagos_detalle', function(Blueprint $table) {
			$table->foreign('pago_id')->references('id')->on('pagos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pagos_detalle', function(Blueprint $table) {
			$table->foreign('tipo_pago_id')->references('id')->on('tipos_pagos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('pagos_detalle', function(Blueprint $table) {
			$table->foreign('medio_de_pago_id')->references('id')->on('medios_de_pago')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cuentas', function(Blueprint $table) {
			$table->foreign('banco_id')->references('id')->on('bancos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cuentas', function(Blueprint $table) {
			$table->foreign('tipocuenta_id')->references('id')->on('tipocuentas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('distribuidores', function(Blueprint $table) {
			$table->dropForeign('distribuidores_organizacion_id_foreign');
		});
		Schema::table('distribuidores', function(Blueprint $table) {
			$table->dropForeign('distribuidores_cuenta_id_foreign');
		});
		Schema::table('comisiones', function(Blueprint $table) {
			$table->dropForeign('comisiones_distribuidor_id_foreign');
		});
		Schema::table('comisiones', function(Blueprint $table) {
			$table->dropForeign('comisiones_tipo_activacion_id_foreign');
		});
		Schema::table('comisiones', function(Blueprint $table) {
			$table->dropForeign('comisiones_semana_id_foreign');
		});
		Schema::table('comisiones_detalle', function(Blueprint $table) {
			$table->dropForeign('comisiones_detalle_comision_id_foreign');
		});
		Schema::table('comisiones_detalle', function(Blueprint $table) {
			$table->dropForeign('comisiones_detalle_distribuidor_id_foreign');
		});
		Schema::table('activaciones', function(Blueprint $table) {
			$table->dropForeign('activaciones_distribuidor_id_foreign');
		});
		Schema::table('activaciones', function(Blueprint $table) {
			$table->dropForeign('activaciones_semana_id_foreign');
		});
		Schema::table('activaciones', function(Blueprint $table) {
			$table->dropForeign('activaciones_tipo_activacion_id_foreign');
		});
		Schema::table('pagos', function(Blueprint $table) {
			$table->dropForeign('pagos_activacion_id_foreign');
		});
		Schema::table('pagos_detalle', function(Blueprint $table) {
			$table->dropForeign('pagos_detalle_pago_id_foreign');
		});
		Schema::table('pagos_detalle', function(Blueprint $table) {
			$table->dropForeign('pagos_detalle_tipo_pago_id_foreign');
		});
		Schema::table('pagos_detalle', function(Blueprint $table) {
			$table->dropForeign('pagos_detalle_medio_de_pago_id_foreign');
		});
		Schema::table('cuentas', function(Blueprint $table) {
			$table->dropForeign('cuentas_banco_id_foreign');
		});
		Schema::table('cuentas', function(Blueprint $table) {
			$table->dropForeign('cuentas_tipocuenta_id_foreign');
		});
	}
}