<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Distribuidor extends Eloquent {

	protected $table = 'distribuidores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fecha_solicitud', 'user_id', 'padre_id', 'organizacion_id', 'equipo', 'hijos', 'nombre', 'paterno', 'materno', 'calle', 'numero', 'colonia', 'entidad_id', 'ciudad', 'codigo_postal', 'sexo', 'fecha_nacimiento', 'telefono_particular', 'telefono_oficina', 'telefono_celular', 'curp', 'rfc', 'cuenta_id');

	public function comisiones()
	{
		return $this->hasMany('App\Comision', 'distribuidor_id');
	}

	public function organizacion()
	{
		return $this->belongsTo('App\Organizacion', 'organizacion_id');
	}

	public function cuentas()
	{
		return $this->hasMany('App\Cuenta', 'cuenta_id');
	}

}