<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pago extends Eloquent {

	protected $table = 'pagos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('precio_unitario', 'total_pagado');

	public function detallePago()
	{
		return $this->hasMany('App\PagoDetalle', 'pago_id');
	}

}