<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Foto extends Model 
{

    protected $table = 'fotos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function likers()
    {
        return $this->hasManyThrough('User', 'FotoLike');
    }

    public function tags()
    {
        return $this->hasManyThrough('Tag', 'FotoTag');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

}