<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function givenLikes()
    {
        return $this->hasMany('Fotolike');
    }

    public function role()
    {
        return $this->belongsTo('Role');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function fotos()
    {
        return $this->hasMany('Foto');
    }

}