<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fotos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fototags', function(Blueprint $table) {
			$table->foreign('foto_id')->references('id')->on('fotos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fototags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fotolikes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fotolikes', function(Blueprint $table) {
			$table->foreign('foto_id')->references('id')->on('fotos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('foto_id')->references('id')->on('fotos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('fotos', function(Blueprint $table) {
			$table->dropForeign('fotos_user_id_foreign');
		});
		Schema::table('fototags', function(Blueprint $table) {
			$table->dropForeign('fototags_foto_id_foreign');
		});
		Schema::table('fototags', function(Blueprint $table) {
			$table->dropForeign('fototags_tag_id_foreign');
		});
		Schema::table('fotolikes', function(Blueprint $table) {
			$table->dropForeign('fotolikes_user_id_foreign');
		});
		Schema::table('fotolikes', function(Blueprint $table) {
			$table->dropForeign('fotolikes_foto_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_foto_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
	}
}