<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shop extends Model 
{

    protected $table = 'shops';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'first_address', 'second_address', 'description', 'website', 'latitude', 'longitude');

    public function comments()
    {
        return $this->hasMany('App\Comment');
    }

    public function deals()
    {
        return $this->hasMany('App\Deal');
    }

    public function images()
    {
        return $this->morphMany('App\Image', 'type');
    }

}