<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('deals', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shops')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deals_users', function(Blueprint $table) {
			$table->foreign('deal_id')->references('id')->on('deals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deals_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shops')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('deals', function(Blueprint $table) {
			$table->dropForeign('deals_shop_id_foreign');
		});
		Schema::table('deals_users', function(Blueprint $table) {
			$table->dropForeign('deals_users_deal_id_foreign');
		});
		Schema::table('deals_users', function(Blueprint $table) {
			$table->dropForeign('deals_users_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_shop_id_foreign');
		});
	}
}