<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('username', 'first_name', 'last_name', 'email');

	public function comments()
	{
		return $this->hasOne('App\Comment');
	}

	public function deals()
	{
		return $this->belongsToMany('App\User');
	}

	public function images()
	{
		return $this->morphMany('App\Image', 'type');
	}

}