<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Deal extends Eloquent {

	protected $table = 'deals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('shop_id', 'code', 'validity', 'quantity', 'description');

	public function images()
	{
		return $this->morphMany('App\Image', 'type');
	}

}