<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('trip_id');
			$table->string('title', 250)->nullable();
			$table->string('slug', 150)->nullable();
			$table->text('message')->nullable();
			$table->string('image', 250)->nullable();
			$table->enum('is_read', array('0', '1'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}