<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 245);
			$table->string('code', 125);
			$table->string('cost', 125);
			$table->integer('expiry_days');
			$table->integer('max_count');
			$table->string('icon', 125);
			$table->string('color_code', 125);
			$table->integer('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}