<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabSubscriberTable extends Migration {

	public function up()
	{
		Schema::create('tabSubscriber', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email_id');
			$table->string('status', 10)->default('Active');
			$table->timestamp('subscribed_at');
			$table->timestamp('unsubscribed_at')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabSubscriber');
	}
}