<?php

namespace LivEnergy;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'tabCity';
    public $timestamps = true;
    protected $fillable = array('name', 'status', 'description', 'owner', 'last_updated_by');

    public function getCountry()
    {
        return $this->hasOne('LivEnergy\Country', 'country_id');
    }

    public function getEvent()
    {
        return $this->hasMany('LivEnergy\Event', 'city_id');
    }

}