<?php

namespace LivEnergy;

use Illuminate\Database\Eloquent\Model;

class ServiceProvider extends Model 
{

    protected $table = 'tabServiceProvider';
    public $timestamps = true;
    protected $fillable = array('avatar', 'name', 'status', 'city_id', 'verified', 'email_id', 'contact_no', 'website', 'description', 'owner', 'last_updated_by');

    public function getServices()
    {
        return $this->hasMany('LivEnergy\Services', 'service_provider_id');
    }

    public function getCities()
    {
        return $this->hasMany('LivEnergy\ServiceCity', 'service_provider_id');
    }

    public function getBrands()
    {
        return $this->hasMany('LivEnergy\ServiceBrand', 'service_provider_id');
    }

    public function getIndustries()
    {
        return $this->hasMany('LivEnergy\ServiceCategory', 'service_provider_id');
    }

}