<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabCategoryTable extends Migration {

	public function up()
	{
		Schema::create('tabCategory', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('status', 10)->default('Active');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->string('parent')->nullable();
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabCategory');
	}
}