<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabCustomerTable extends Migration {

	public function up()
	{
		Schema::create('tabCustomer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('gender', 10)->default('Male');
			$table->date('dob')->nullable();
			$table->string('email_id');
			$table->string('contact_no')->nullable();
			$table->text('notes')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabCustomer');
	}
}