<?php

namespace LivEnergy;

class Supplier extends Eloquent {

	protected $table = 'tabSupplier';
	public $timestamps = true;
	protected $fillable = array('name', 'avatar', 'status', 'tagline', 'verified', 'email_id', 'contact_no', 'address', 'city_id', 'website', 'country', 'type', 'no_of_employees', 'legal_status', 'member_since', 'description', 'owner', 'last_updated_by');

	public function getSupplierIndustries()
	{
		return $this->hasMany('LivEnergy\SupplierCategory', 'supplier_id');
	}

	public function getSupplierCities()
	{
		return $this->hasMany('LivEnergy\SupplierCity', 'supplier_id');
	}

	public function getProductSupplier()
	{
		return $this->hasMany('LivEnergy\Product', 'supplier_id');
	}

	public function getSupplierDetail()
	{
		return $this->hasMany('Livenergy\SupplierDetail', 'supplier_id');
	}

}