<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_store', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_store', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('meet_types', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_user_id_foreign');
		});
		Schema::table('user_store', function(Blueprint $table) {
			$table->dropForeign('user_store_user_id_foreign');
		});
		Schema::table('user_store', function(Blueprint $table) {
			$table->dropForeign('user_store_store_id_foreign');
		});
		Schema::table('meet_types', function(Blueprint $table) {
			$table->dropForeign('meet_types_store_id_foreign');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->dropForeign('complaints_user_id_foreign');
		});
	}
}