<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('content');
			$table->double('price');
			$table->double('offer_price');
			$table->date('start_at');
			$table->date('end_at');
			$table->integer('restaurant_id');
			$table->timestamps();
			$table->string('image', 255);
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}