<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('project_name');
			$table->string('project_dev_url');
			$table->string('project_sandbox_url');
			$table->string('project_live_url');
			$table->string('domain_manager');
			$table->timestamps();
			$table->enum('deleted', array('Y', 'N'));
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}