<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectPayment extends Eloquent {

	protected $table = 'project_payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function payment()
	{
		return $this->belongsTo('Models\Payment', 'payment_id');
	}

	public function project()
	{
		return $this->hasMany('Models\Project');
	}

}