<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('toman_wallet_id')->unsigned()->nullable()->default('NULL');
			$table->float('amount', 10.6);
			$table->string('gateway_ref')->nullable()->default('NULL');
			$table->string('gateway_tracking');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}