<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cryptocurrencie_wallets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cryptocurrencie_wallets', function(Blueprint $table) {
			$table->foreign('cryptocurrency_id')->references('id')->on('cryptocurrencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('toman_wallets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('buys', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('buys', function(Blueprint $table) {
			$table->foreign('cryptocurrency_id')->references('id')->on('cryptocurrencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sells', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sells', function(Blueprint $table) {
			$table->foreign('cryptocurrency_id')->references('id')->on('cryptocurrencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('buy_id')->references('id')->on('buys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('sell_id')->references('id')->on('sells')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('toman_wallet_id')->references('id')->on('toman_wallets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('cryptocurrency_wallet_id')->references('id')->on('cryptocurrencie_wallets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('toman_wallet_id')->references('id')->on('toman_wallets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('cryptocurrencie_wallets', function(Blueprint $table) {
			$table->dropForeign('cryptocurrencie_wallets_user_id_foreign');
		});
		Schema::table('cryptocurrencie_wallets', function(Blueprint $table) {
			$table->dropForeign('cryptocurrencie_wallets_cryptocurrency_id_foreign');
		});
		Schema::table('toman_wallets', function(Blueprint $table) {
			$table->dropForeign('toman_wallets_user_id_foreign');
		});
		Schema::table('buys', function(Blueprint $table) {
			$table->dropForeign('buys_user_id_foreign');
		});
		Schema::table('buys', function(Blueprint $table) {
			$table->dropForeign('buys_cryptocurrency_id_foreign');
		});
		Schema::table('sells', function(Blueprint $table) {
			$table->dropForeign('sells_user_id_foreign');
		});
		Schema::table('sells', function(Blueprint $table) {
			$table->dropForeign('sells_cryptocurrency_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_buy_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_sell_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_toman_wallet_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_cryptocurrency_wallet_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_toman_wallet_id_foreign');
		});
	}
}