<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('company_name', 'addr_line_1', 'addr_line_2', 'website', 'email', 'phone_no');
    protected $visible = array('company_name', 'addr_line_1', 'addr_line_2', 'website', 'email', 'phone_no');

    public function users()
    {
        return $this->hasMany('App\User');
    }

    public function locations()
    {
        return $this->hasMany('App\Location');
    }

    public function units()
    {
        return $this->hasMany('App\Unit');
    }

}