<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('location_name', 'addr_line_1', 'addr_line_2', 'company_id');
    protected $visible = array('location_name', 'addr_line_1', 'addr_line_2', 'company_id');

    public function company()
    {
        return $this->belongsTo('App\Company');
    }

    public function units()
    {
        return $this->hasMany('App\Unit');
    }

}